#############################################################################
#
#              GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/View.py,v $
# Version:     $RCSfile: View.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1998-1999, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
View.py

The base class for view frames created from template frames during
view instantiation.  The methods on this class perform the default
behaviour, which can be overridden by NewtonScript functions in
user-defined view frames.

hmmm.  some problems there somewhere ...

"""

#############################################################################

import sys

from   GnutOS.Classes           import Frame
from   GnutOS.ViewConstants     import *


#############################################################################

class View(Frame):
    """the base NewtonScript-accessable View class."""

    def __init__(self, template, parent):
	"""Create a new view instance, using a template frame."""

	#-- create the View frame
	Frame.__init__(self)
	self["_parent"] = parent

	#-- read the viewClass and create the pView
	self["viewCObject"] = pView(self)

	#-- setupFormScript
	self.ViewSetupFormScript()

	#-- read viewFlags, viewFormat, viewBounds, and declareSelf

	#-- viewSetupChildrenScript
	self.ViewSetupChildrenScript()

	#-- children
	#-- read viewJustify (and adjust viewBounds)
	#-- viewSetupDone
	self.ViewSetupDoneScript()

	#-- display
	if self.has_key("viewFlags") and (self["viewFlags"] & vVisible):
	    self["_pview"].draw()
    
	self.ViewShowScript()

	#-- viewDrawScript
	self.ViewDrawScript()
	if self.has_key("viewChildren") or self.has_key("stepChildren"):
	    for child in self["viewChildren"] + self["stepChildren"]:
		child["_pview"].draw()
		child.ViewDrawScript()

	#-- done!
	return

    def ChildViewFrames(self):
	pass

    def Parent(self):
	pass

    def GetView(self, view):
	pass

    def Open(self):
	pass

    def Close(self):
	pass

    def Toggle(self):
	pass

    def Show(self):
	pass

    def Hide(self):
	pass

    def Dirty(self):
	pass

    def OffsetView(self, dx, dy):
	pass

    def SyncView(self):
	pass

    def MoveBehind(self, view):
	pass

    def FilterDialog(self):
	pass

    def ModalDialog(self):
	pass

    def GlobalBox(self):
	pass

    def GlobalOuterBox(self):
	pass

    def LocalBox(self):
	pass

    def DirtyBox(self, boundsFrame):
	pass

    def GetDrawBox(self):
	pass

    def Effect(self, effect, offScreen, sounds, methodsName, methodParameters):
	pass

    def SlideEffect(self, contentOffset, viewOffset, sound, methodName, methodParameters):
	pass

    def RevealEffect(self, distance, bounds, sound, methodName, methodParameters):
	pass

    def Delete(self, methodName, methodParameters):
	pass

    def Drag(self, unit, dragBounds):
	pass

    def DragAndDrop(self, unit, bounds, limitBounds, copy, dragInfo):
	pass

    def SetOrigin(self, originX, originY):
	pass

    def SyncScroll(self, what, index, upDOwn):
	pass

    def Hilite(self, on):
	pass

    def HiliteUnique(self, on):
	pass

    def TackHilite(self, unit):
	pass

    def TrackButton(self, unit):
	pass

    def SetHilite(self, start, end, unique):
	pass

    def RedoChildren(self):
	pass

    def SyncChildren(self):
	pass

    def LayoutTable(self, tableDefinition, columnStart, rowStart):
	pass

    def LayoutColumn(self, childview, index):
	pass

    def SetPopup(self):
	pass

    def ViewSetupFormScript(self):
	pass

    def ViewSetupChildrenScript(self):
	pass

    def ViewSetupDoneScript(self):
	pass

    def ViewQuitScript(self):
	pass

    def ViewPostQuitScript(self):
	pass

    def ViewShowScript(self):
	pass

    def ViewHideScript(self):
	pass

    def ViewDrawScript(self):
	pass

    def ViewHiliteScript(self, on):
	pass

    def ReorientToScreen(self):
	pass

    def ViewScrollDownScript(self):
	pass

    def ViewScrollUpScript(self):
	pass

    def ViewOverviewScript(self):
	pass

    def ViewAddChildScript(self, child):
	pass

    def ViewChangedScript(self, slot, view):
	pass

    def ViewDropChildScript(self, child):
	pass

    def ViewIdleScript(self):
	pass

    def ViewDrawDragDataScript(self, bounds):
	pass

    def ViewDrawFragBackgroundScript(self, bounds, copy):
	pass

    def ViewGetDropTypesScript(self, currentPoint):
	pass

    def ViewFindTargetScript(self, dragInfo):
	pass

    def ViewDragFeedbackScript(dragInfo, currentPoint, show):
	pass

    def ViewGetDropDataScript(self, dragType, dragRef):
	pass

    def ViewDropScript(self, dropType, dropData, dropPt):
	pass

    def ViewDropMoveScript(self, dragRef, offset, lastDragPt, copy):
	pass

    def ViewDropRemoveScript(self, dragRef):
	pass

    def ViewDropDoneScript(self):
	pass



    def ViewClickScript(self):
	print "view clicked ..."
	return

    
#############################################################################

if __name__ == "__main__":
    pass


#############################################################################
