//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <setjmp.h>
#include <signal.h>
#include "Newton.H"

char Read_C_rcsid[] = "$Id: Read.C,v 1.3 1997/08/24 21:38:02 spoonman Exp $";

// where to jump if a timeout
static jmp_buf TimeoutJMP;
// boolean timedout flag
static int timedout=FALSE;

// static signal handler for ReadChar timeouts
static void ReadCharTimeout(int sig)
  {
  fprintf(stderr,"Newton: timeout waiting for data\n");
  timedout = TRUE;
  longjmp(TimeoutJMP, 1);
  };

// Read a character from NewtonDevice
int Newton::ReadChar(char &letter)
  {
  char *tmpChars=NULL;
  int ret=NewtonEOF;

  tmpChars = new char[2];

  // timeout if nothing is read...
  signal(SIGALRM, ReadCharTimeout);
  alarm(5);
  if (!setjmp(TimeoutJMP) && (timedout == FALSE)) 
    {
    NewtonDevice.read(tmpChars, 1);
    letter = tmpChars[0];
    delete [] tmpChars;
    timedout = FALSE;
    ret = NewtonOK;
    };
  alarm(0);
  signal(SIGALRM, SIG_DFL);
  return(ret);
  };

// Read a line from the NewtonDevice until NewtonEOL
int Newton::ReadLine(char **theChars)
  {
  String tmpString;
  int ret;

  if ((ret = ReadLine(tmpString)) == NewtonOK)
    {
    if (*theChars != NULL)
      {    
      delete [] *theChars;
      };
    *theChars = new char[tmpString.length() + 1];
    sprintf(*theChars,"%s",tmpString.chars());
    }
  else
    {
    *theChars = NULL; 
    };
  return(ret);
  };

int Newton::ReadLine(String &theString)
  {
  char letter;
  String tmpString;
  int ret=NewtonOK;

  ReadChar(letter);

  // read until NewtonEOL
  while ((letter != '\r') && (letter != '\n') && (timedout == FALSE))
    {
    tmpString += letter;
    letter = letter;
    ReadChar(letter);
    };

  if (timedout == FALSE)
    {
    theString = tmpString;
    }
  else
    {
    theString = "";
    ret = NewtonEOF;
    };
  return(ret);
  };

// Read from NewtonDevice to a file
int Newton::ReadToFile(const String filename)
  {
  return(ReadToFile(filename.chars()));
  };

int Newton::ReadToFile(const char *filename)
  {
  FILE *FilePointer;
  int ret;

  if (!strcmp(filename,"-"))  // if user wants stdout
    {
    ret = ReadToFile(stdout);
    }
  else
    {
    if ((FilePointer=fopen(filename, "w")) == NULL)
      {
      fprintf(stderr,"Newton: error opening file: %s\n",filename);
      return(NewtonERROR);
      };
    ret = ReadToFile(FilePointer);
    fclose(FilePointer);
    };
  return(ret);
  };

// Read from NewtonDevice to a file
int Newton::ReadToFile(const FILE *FilePointer)
  {
  String string;

  ReadLine(string);
  while (string + "\n" != SlurpeeBYE)
    {
    fprintf((FILE *)FilePointer, "%s\n", string.chars());
    fflush((FILE *)FilePointer);
    ReadLine(string);
    };
  return(NewtonOK);
  };

