#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# install.pl
#---------------------------------------------------------------------

# $Log: install.pl,v $
# Revision 1.14  1998/09/06 11:08:29  reinhold
# Version nach 1.29 geaendert.
#
# Revision 1.13  1998/08/28 16:36:39  kalli
# tknl nach tknl.tcl geaendert
#
# Revision 1.12  1998/04/10 15:15:11  kalli
# Rev. 1.28
#
# Revision 1.11  1998/03/27 20:41:10  kalli
# Browser wird in newtonlink.config gepatcht
#
# Revision 1.10  1998/03/21 14:37:52  kalli
# Versionsnummer auf 1.27 geaendert
#
# Revision 1.9  1998/03/16 14:59:33  kalli
# fuer Version 1.27
#
# Revision 1.8  1998/03/12 20:57:24  kalli
# Device auf /dev/newton geaendert
#
# Revision 1.7  1998/03/12 20:44:40  kalli
# System_Mode und Device werden abgefragt
#
# Revision 1.6  1998/03/07 17:59:56  kalli
# *** empty log message ***
#
# Revision 1.5  1998/02/14 13:56:21  kalli
# Uebergabeparameter -lfs und -rmlfs eingefuehrt
#
# Revision 1.4  1997/12/17 09:37:53  kalli
# Erste Version lauffaehig.
#
# Revision 1.3  1997/12/17 07:37:15  kalli
# *** empty log message ***
#
# Revision 1.2  1997/12/16 13:21:22  kalli
# *** empty log message ***
#
# Revision 1.1  1997/12/08 20:35:39  kalli
# Initial revision
#

# actual Newtonlink version number to install 
$version = "1.29";



#---------------------------------------------------------------------
# SetDefaults - Set some default values
#---------------------------------------------------------------------

sub SetDefaults {

    $INSTALL     = "install";
    $PERL_EXE    = "/usr/bin/perl";
    $WISH_EXE    = "/usr/bin/wish";
    $BROWSER_EXE = "netscape";
    
    $BAS_DIR     = "/usr/local/newtonlink";
    $LIB_DIR     = "$BAS_DIR";
    $DOC_DIR     = "$BAS_DIR"; 
    $CFG_DIR     = "$BAS_DIR";
    $MAN_DIR     = "/usr/local/man/man1";
    $PID_DIR     = "/tmp";
}




#---------------------------------------------------------------------
# SetLFSDefaults - Set default values for LFS
#---------------------------------------------------------------------

sub SetLFSDefaults {

    $BAS_DIR     = "/usr/lib/newtonlink";
    $LIB_DIR     = "$BAS_DIR-$version";
    $DOC_DIR     = "/usr/doc/newtonlink-$version"; 
    $CFG_DIR     = "/etc";
    $MAN_DIR     = "/usr/local/man/man1";
    $PID_DIR     = "/var/run";
}




#---------------------------------------------------------------------
# PrintInstallValues - Print choosen values
#---------------------------------------------------------------------

sub PrintInstallValues {

    print "Your Perl5 executable :                     $PERL_EXE\n";
    print "Your Tk-shell wish :                        $WISH_EXE\n";
    print "Your install command :                      $INSTALL\n";
    print "Your HTML browser :                         $BROWSER_EXE\n";
    print "Directory for the Newtonlink files :        $LIB_DIR\n";
    print "Directory for the Newtonlink doc files :    $DOC_DIR\n";
    print "Directory for the systemwide config file :  $CFG_DIR\n";
    print "Directory for the Newtonlink PID file :     $PID_DIR\n";
    print "Directory for the Newtonlink man file :     $MAN_DIR\n";
}




#---------------------------------------------------------------------
# PatchFile_newtonlink_config - Patch variables into file
#---------------------------------------------------------------------

sub PatchFile_newtonlink_config {

    open (NLCFILE, "newtonlink.config")  || die "Can't open File : $!\n";
    # Open newtonlink sed file
    open (NLCSEDFILE, "> newtonlink.config.sed")  || die "Can't open File : $!\n";

    while (<NLCFILE>) {
	s/S_NEWTONLINK_PIDFILEDIR_S/$PID_DIR/g;
        s/S_NEWTONLINK_SYSMODE_S/UNIX/g;
	s/S_NEWTONLINK_BROWSER_S/$BROWSER_EXE/g;
        s/S_NEWTONLINK_SERDEV_S/\/dev\/newton/g;
	print NLCSEDFILE $_;
    }     

    # close files
    close (NLCFILE);
    close (NLCSEDFILE);
	    
}




#---------------------------------------------------------------------
# PatchFile_newtonlink - Patch variables into file
#---------------------------------------------------------------------

sub PatchFile_newtonlink {

    open (NLFILE, "newtonlink")  || die "Can't open File : $!\n";
    # Open newtonlink sed file
    open (NLSEDFILE, "> newtonlink.sed")  || die "Can't open File : $!\n";

    while (<NLFILE>) {
        s/S_PERLBINARY_S/$PERL_EXE/g;
	s/S_NEWTONLINK_INSTALLDIR_S/$LIB_DIR/g;
	s/S_NEWTONLINK_CONFIGFILEDIR_S/$CFG_DIR/g;
	print NLSEDFILE $_;
    }     

    # close files
    close (NLFILE);
    close (NLSEDFILE);
	    
}




#---------------------------------------------------------------------
# PatchFile_tknl - Patch variables into file
#---------------------------------------------------------------------

sub PatchFile_tknl {

    open (TKNLFILE, "tknl.tcl")  || die "Can't open File : $!\n";
    # Open tknl sed file
    open (TKNLSEDFILE, "> tknl.sed")  || die "Can't open File : $!\n";

    while (<TKNLFILE>) {
	s/S_WISHBINARY_S/$WISH_EXE/g;
	s/S_NEWTONLINK_INSTALLDIR_S/$LIB_DIR/g;
        print TKNLSEDFILE $_;
    }
         
    # close files
    close (TKNLFILE);
    close (TKNLSEDFILE);

}




#---------------------------------------------------------------------
# FinalInstall - Final install procedure
#---------------------------------------------------------------------

sub FinalInstall {

    system "$INSTALL -m 755 -d $DOC_DIR";
    system "$INSTALL -m 644 COPYRIGHT GNU_GPL README $DOC_DIR";
    system "$INSTALL -m 755 -d $LIB_DIR";
    system "$INSTALL -m 644 COPYRIGHT GNU_GPL README $LIB_DIR";
    system "$INSTALL -m 755 newtonlink.sed $LIB_DIR/newtonlink";
    system "$INSTALL -m 755 tknl.sed $LIB_DIR/tknl.tcl";
    system "$INSTALL -m 644 *.pl $LIB_DIR";
    system "$INSTALL -m 644 newtonlink.xbm $LIB_DIR";
    system "$INSTALL -m 755 -d $LIB_DIR/icons";
    system "$INSTALL -m 644 icons/* $LIB_DIR/icons";
    system "$INSTALL -m 755 -d $LIB_DIR/doc";
    system "$INSTALL -m 644 doc/*.html $LIB_DIR/doc";
    system "$INSTALL -m 755 -d $LIB_DIR/doc/Images";
    system "$INSTALL -m 644 doc/Images/* $LIB_DIR/doc/Images";
    system "$INSTALL -m 755 -d $MAN_DIR";
    system "$INSTALL -m 644 newtonlink.man $MAN_DIR/newtonlink.1";
    system "$INSTALL -m 755 -d $CFG_DIR";
    system "$INSTALL -m 644 newtonlink.config.sed $CFG_DIR/newtonlink.config";
    system "$INSTALL -m 644 newtonlink.config.sed $LIB_DIR/newtonlink.config";
}




#---------------------------------------------------------------------
# InstallNonLFS - Install Newtonlink interactive
#---------------------------------------------------------------------

sub InstallNonLFS {

    print "OK, so I have to ask you some questions :\n\n";
    $isok = "no";

    while ($isok eq "no") {
        
    	print "Path to your Perl5 executable [$PERL_EXE] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $PERL_EXE = $a;
    	}

    	print "Path to your Tk-shell wish [$WISH_EXE] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $WISH_EXE = $a;
    	}

    	print "Your install command [$INSTALL] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $INSTALL = $a;
    	}

    	print "Your HTML browser [$BROWSER_EXE] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $BROWSER_EXE = $a;
    	}

    	print "Directory for the Newtonlink files [$LIB_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $LIB_DIR = $a;
    	}

    	print "Directory for the Newtonlink doc files [$DOC_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $DOC_DIR = $a;
    	}


    	print "Directory for the systemwide config file [$CFG_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $CFG_DIR = $a;
    	}

    	print "Directory for the Newtonlink man file [$MAN_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $MAN_DIR = $a;
    	}


    	print "Directory for Newtonlid PID file [$PID_DIR] : ";
    	$a = <STDIN>;
    	chop ($a);
    	if ($a ne "") {
	    $PID_DIR = $a;
    	}
    
    	print "\nThis is your choosen configuration :\n";
	&PrintInstallValues;

    	while ( ($a ne "y") && ($a ne "n") && ($a ne "q") ) {
            print "Is this ok ? (y|n|q) ";
            $a = <STDIN>;
            chop ($a);
        }

    	if ($a eq "q") {
            print "Installation aborted\n";
            exit;
	} elsif ($a eq "n") {
	    $isok = "no";
	    print "\n";	    	    
        } else {
	    $isok = "yes";
            print "Starting installation, please wait ...\n";

	    # patch informations into files
	    &PatchFile_newtonlink_config;
	    &PatchFile_newtonlink;
	    &PatchFile_tknl;
	    # install
	    &FinalInstall;   	    
        }
    }
}




#---------------------------------------------------------------------
# InstallLFS - Install Newtonlink due to the Linux Filesystem Standard
#---------------------------------------------------------------------

sub InstallLFS {

    &PrintInstallValues;
    print "Will create symbolic link $LIB_DIR -> $BAS_DIR\n";	
    print "Will create symbolic link $BAS_DIR/newtonlink -> /usr/bin/newtonlink\n";	

    $a = "";
    print "\n";

    if ( ($a eq "q") || ($a eq "n") ) {
        print "Installation aborted\n";
        exit;
    
    } else {
    
        print "\nStarting installation, please wait ...\n";

	# patch informations into files
	&PatchFile_newtonlink_config;
	&PatchFile_newtonlink;
	&PatchFile_tknl;
	# install
        &FinalInstall;
	# create symlinks
	system "ln -s $LIB_DIR $BAS_DIR";
	system "ln -s $BAS_DIR/newtonlink /usr/bin/newtonlink";
    }
}




#---------------------------------------------------------------------
# RemoveLFS - Remove Newtonlink due to the Linux Filesystem Standard
#---------------------------------------------------------------------

sub RemoveLFS {

    print "\nRemoving Newtonlink, please wait ...\n";
    system "rm -rf $DOC_DIR";
    system "rm -rf $LIB_DIR";
    system "rm $BAS_DIR";
    system "rm $MAN_DIR/newtonlink.1";
    system "rm $CFG_DIR/newtonlink.config";
    system "rm /usr/bin/newtonlink";
}



print "\nWelcome to the Newtonlink install procedure\n\n";

# set some defaults
&SetDefaults;

# get system type
$SystemType = `uname`;
 
# Look for command line parameters
if ($ARGV[0] eq "-lfs") {
    &SetLFSDefaults;
    &InstallLFS;
    
} elsif ($ARGV[0] eq "-rmlfs") {
    &SetLFSDefaults;
    &RemoveLFS;

} elsif ($SystemType eq "Linux\n") {

    $a = "";   
    while ( ($a ne "y") && ($a ne "n") && ($a ne "q") && ($a ne "remove") ) {
        print "It looks like you have a Linux system, would you like to install\n";
        print "Newtonlink due to the Linux Filesystem Standard (y|n|q) ";
        $a = <STDIN>;
        chop ($a);
    }

    if ($a eq "q") {
        print "Installation aborted\n";
        exit;
    
    } elsif ($a eq "y") {
        print "\n";
	&SetLFSDefaults;
        &InstallLFS;
	
    } elsif ($a eq "remove") {
	&SetLFSDefaults;
        &RemoveLFS;

    } else {
        &InstallNonLFS;
    }   

} else {
    # for all other non Linuxes :
    &InstallNonLFS;
}





